import { getCurrentUserFromServer } from "../lib/session.amplify"

type AuthenticatedState = {
  __tag: "AUTHENTICATED",
  user: Awaited<ReturnType<typeof getCurrentUserFromServer>>
}

type UnauthenticatedState = {
  __tag: "UNAUTHENTICATED",
}

type NotNeededAuthenticationState = {
  __tag: "NOT_NEEDED",
}


export type AuthenticationState = NotNeededAuthenticationState | AuthenticatedState | UnauthenticatedState | undefined
